void
genc(register int c)
{
	if (generate) {
		*((seg[segment].outp)++) = c;
	}
}

void
gens(register char *s)
{
	while (*s) {
		genc(*s);
		++s;
	}
}

#define	genf(args...) \
	if (generate) { \
		sprintf(seg[segment].outp, args); \
		seg[segment].outp += strlen(seg[segment].outp); \
	}

void
genhex(register int b)
{
	/* place one hex pair on output & adjust checksum */

	b = (b & 0xff);
	chksum += b;
	genf("%02x", b);
}

void
geni8hex(register int byte)
{
	/* generate another byte of code to hex file */
	register int i;

	if (bytesgen++ > 0) {
		/* if we have generated at least one byte of code */
		if ((hexbase + hexcnt) == lc) {
			if (hexcnt < MAXHEX) {
				/* simply add hex of byte to stuff there */
				hexbyt[hexcnt++] = byte;
				return;
			}
		}

		/* output this line, we have reached a break */
		genc(':'); chksum = 0;		/* begin record */
		genhex(hexcnt);			/* length field */
		genhex(hexbase >> 8);		/* record address */
		genhex(hexbase & 0x00ff);
		genhex(0);			/* type zero */
		i = 0;
		while (i < hexcnt) {
			genhex(hexbyt[i++]);	/* the data */
		}
		genhex(256 - chksum);		/* checksum */
		genc('\n');			/* end record */
	}

	/* start a new line for the byte at lc */
	hexbase = lc;
	hexbyt[0] = byte;
	hexcnt = 1;
}

void
gensrec(register int byte)
{
	/* generate another byte of code to hex file */
	register int i;

	if (bytesgen++ > 0) {
		/* if we have generated at least one byte of code */
		if ((hexbase + hexcnt) == lc) {
			if (hexcnt < MAXHEX) {
				/* simply add hex of byte to stuff there */
				hexbyt[hexcnt++] = byte;
				return;
			}
		}

		/* output this line, we have reached a break */
		gens("S1"); chksum = 0;		/* begin record */
		genhex(hexcnt + 3);		/* length field */
		genhex(hexbase >> 8);		/* record address */
		genhex(hexbase & 0x00ff);
		i = 0;
		while (i < hexcnt) {
			genhex(hexbyt[i++]);	/* the data */
		}
		genhex(~chksum);		/* checksum */
		genc('\n');			/* end record */
	}

	/* start a new line for the byte at lc */
	hexbase = lc;
	hexbyt[0] = byte;
	hexcnt = 1;
}

void
genmif(register int width,
register int val)
{
	register int d = seg[segment].depth - 1;
	register int b;

	for (b=0; (1<<b)<=d; ++b) ;

	genf("%0*x:%0*x;\n",
	     ((b + 3) / 4),
	     lc,
	     ((width + 3) / 4),
	     val);
}

void
genvmem(register int width,
register int val)
{
	if (seg[segment].pos != lc) {
		genf("@%04x\n", (0xffff & lc));
	}

	genf("%0*x\n", ((width + 3) / 4), val);
}

void
genobj(register int width,
register int val)
{
	register Attrib aikoutput = seg[segment].format;

	if (aikoutput == i8hex) {
		if (width > 8) {
			aikwarn("value too wide for I8HEX output (%d bits)", width);
		}
		geni8hex(val);		
	} else if (aikoutput == srec) {
		if (width > 8) {
			aikwarn("value too wide for SREC output (%d bits)", width);
		}
		gensrec(val);
	} else if (aikoutput == mif) {
		genmif(width, val);
	} else {
		genvmem(width, val);
	}

	seg[segment].pos = ++lc;
}

void
gen(register int bits,
register long long int val)
{
	register int width = seg[segment].width;

	if ((bits > width) && (sym[aiklowfirst].val == 0)) {
		gen((bits - width), (val >> width));
	}

	if (bits) {
		/* Output low bits */
		register unsigned int m = ((bits > width) ? width : bits);
		register unsigned int v = (val & ((1LL << m) - 1LL));
		genobj(width, v);
	}

	if ((bits > width) && (sym[aiklowfirst].val != 0)) {
		gen((bits - width), (val >> width));
	}
}

void
beginsegment(void)
{
	register Attrib aikoutput = seg[segment].format;

	if (aikoutput == i8hex) {
		bytesgen = 0;
		chksum = 0;
		hexbase = 0;
		hexcnt = 0;
	} else if (aikoutput == srec) {
		bytesgen = 0;
		chksum = 0;
		hexbase = 0;
		hexcnt = 0;
	} else if (aikoutput == mif) {
		genf(
"DEPTH = %d;\n"
"WIDTH = %d;\n"
"ADDRESS_RADIX = HEX;\n"
"DATA_RADIX = HEX;\n"
"CONTENT\n"
"BEGIN\n"
"\n",
		     seg[segment].depth,
		     seg[segment].width);
	} else {
		gens("//generated by AIK version " VERSTRING "\n");
	}
}

void
endsegment(void)
{
	register Attrib aikoutput = seg[segment].format;

	if (aikoutput == i8hex) {
		lc = -lc;	/* force record dump */
		geni8hex(0);
		lc = -lc;
		--bytesgen;

		gens(":0000000000\n");
	} else if (aikoutput == srec) {
		lc = -lc;	/* force record dump */
		gensrec(0);
		lc = -lc;
		--bytesgen;

		gens("S9\n");
	} else if (aikoutput == mif) {
		gens("\nEND\n");
	} else {
		gens("//end\n");
	}
}
